// 13 Jun 2018
//    *** MAJOR REWRITE ***
//    Polling mechanism so that all poll requests are sent out at once
//    rather than sequentially.  It makes much more sense.
// 12 Jul 2018
//    * Files to go in the watched list can now be specified by adding 'watched'as a bare
//      attribute to SCRIPT and LINK tags.
//    * Removed the watch everything as that was causing too many timeouts when scanning
//      a dozen files or more.
// 01 Feb 2018
//    Changed behaviour when no watch list given to use all scripts and links on page (since removed)
// 30 Dec 2017
//    Negligible change to .fail response args
// 13 Sep 2017
//    Improved handling of missing files in watched list
//  4 Jan 2017
//    Hacked the ajax call so that it works with jquery 3 using .done instead of .success
// 28 Dec 2016 
//    Traps 404 in watched list with alert

// Slap this on a web page to get automatic browser refreshes
// whenever the source(s) change.  Also, when reloading, save
// any state including input element values and style classes.
//
// 19 May 2015
// Peter Fox
// author@vulpeculox.net
// www.vulpeculox.net
// Full instructions at vulpeculox.net/misc/jsjq/reload/index.htm

var AutoReload = {
  version    : 'See date of source file.',
  _int       : undefined,                // nonce for set/clear interval
  _interval  : 2000,                     // milliseconds between testing for changes
  _Urls      : [window.location.href],   // array of files to check  (No wildcards)
  _firsts    : [],                       // preventing reload on first test
  _lsKey     : 'AR',                     // key for local storage.  Hashed so each page is different
  _state     : {},                       // used during load/save state
  _blockSave : false,                    // true if we want to prevent saving state during a Purge()
  _latencyId : undefined,                // Id of a screen element to show time since last reload
  _loadStamp : 0,                        // time (integer,ms) of last reload 
  _latencyShownStamp : -1,               // time (integer,ms) of last showing of latency stamp  
  _timeOut   : 4000,                     // time allowed for all responses ms 
  _firstTime : true,                     // is this the first poll
  _waiting   : [],                       // URLs requested but not yet responded
  _pollCompletedAt : -1,                 // when all polls returned 
  _gap : 1000,                           // moving average gap watching  
  _timeoutCount : 0,                     // for console log of repeated t/outs
  // This collects DOM elements that have been marked with 
  //  .AR-saveClasses, .AR-saveVal and .AR-saveHTML .AR-saveChecked
  // It builds the _state object which is then written
  // to local storage  
  // NB Can be replaced via Start configuration
  //---------------------------------------------------------- 
  _saveState : function(){
    if(AutoReload._blockSave){return;}
    AutoReload._state = {classes:{},val:{},html:{},checked:{},extras:{}};
    $.each($('.AR-saveClasses'),function(I,E){
      var el = $(E);
      AutoReload._state.classes[el.attr('id')]=el.attr('class');
    });
    $.each($('.AR-saveVal'),function(I,E){
      var el = $(E);
      AutoReload._state.val[el.attr('id')]=el.val();
    });
    $.each($('.AR-saveHtml'),function(I,E){
      var el = $(E);
      AutoReload._state.html[el.attr('id')]=el.html();
    });
    $.each($('.AR-saveChecked'),function(I,E){
      var el = $(E);
      AutoReload._state.checked[el.attr('id')]=el.is(':checked');
    });
    AutoReload._state.extras.scrollTop = $(document).scrollTop();
    localStorage.setItem(AutoReload._lsKey,JSON.stringify(AutoReload._state));
  },
  
  
  // Reads local storage then sets val, html or classes of DOM
  // elements as identified by id  
  // NB Can be replaced via Start configuration
  //---------------------------------------------------------- 
  _loadState : function(){
    var ss =  localStorage.getItem(AutoReload._lsKey);
    if(ss){
      var id;
      AutoReload._state = JSON.parse(ss);
      for(id in AutoReload._state.classes){
        $('#'+id).attr('class',AutoReload._state.classes[id]);
      }  
      for(id in AutoReload._state.val){
        $('#'+id).val(AutoReload._state.val[id]);
      }  
      for(id in AutoReload._state.html){
        $('#'+id).html(AutoReload._state.html[id]);
      }
      for(id in AutoReload._state.checked){
        $('#'+id).attr('checked',AutoReload._state.checked[id]);
      }
      $(document).scrollTop(AutoReload._state.extras.scrollTop);
    }  
  },
    
    
    
    

  // Main watch for changes function
  // Called by the timer
  //--------------------------------     
  _TestUrls : function(){

  
    // looking at how long between last poll response and next poll start
    if(AutoReload._pollCompletedAt>0){
      var msGap = Date.now() - AutoReload._pollCompletedAt;
      AutoReload._gap = ((AutoReload._gap * 4) + (msGap*1))/5;   // moving average
      if(AutoReload._gap < 1000){
        console.log('Average gap:'+AutoReload._gap+' Current:'+msGap);
      }  
      
    }  
      
    
    // ***********************************************************
    // *** MOSTLY IGNORE MISSING/TIMEOUTS                      ***
    // *** Because we're (mostly) using 'watched' in HTML head *** 
    // *** (Can't find reason for almost complete fall-over    ***
    // *** which happens from time to time.  Poss F12 delays)  ***
    // ***********************************************************
    // sweep-up from previous poll
    // Are there any urls which didn't respond (missing or t/out)
    if(AutoReload._waiting.length>0){   // some responses are late or missing, left-over from previous poll
      AutoReload._timeoutCount++;
      console.log('TIMED-OUT('+AutoReload._timeoutCount+'):'+AutoReload._waiting.join('|'));
      var msg = "autoReload repeatedly can't find files\n"+AutoReload._waiting.join('\n')+'\nAutoreloading halted\n(Timeout secs='+(AutoReload._interval/1000)+')';
      AutoReload._waiting = [];  // ignore
      if(AutoReload._timeoutCount > 10){
        clearInterval(AutoReload._int);  // be tidy and stop polling
        var el = $('#'+AutoReload._latencyId).html('<span class=invert>T/out</span>');
        alert(msg);
      }  
    }
    
    // possibly show seconds since last load
    if(AutoReload._latencyId){
      var dnow = Date.now();
      var elapsedSec = (dnow - AutoReload._loadStamp)/1000;     // how long has it been running
      var showingSec = Number.parseInt($('#'+AutoReload._latencyId).text(),10);
      if((showingSec<0)||(showingSec>99999)){showingSec=0;}            
      var waitInt = (elapsedSec<25) ? 4 : 11; 
      if(showingSec<(elapsedSec-waitInt)){ 
        AutoReload._latencyShownStamp = dnow;
        var el = $('#'+AutoReload._latencyId);
        el.html(elapsedSec.toFixed());
      }        
    }                
    
    // each url has its own flag to say if this is the first time we've looked for it
    if(AutoReload._firstTime){
      AutoReload._firsts=AutoReload._Urls.map(function(){return true;});
      AutoReload._firstTime = false;
    }  

    // fire off a wave of tests
    AutoReload._waiting = [];   // names of requests
    AutoReload._Urls.forEach(function(U){
      AutoReload._waiting.push(U);
      //console.log('testing:',U);
      
      // async call
      $.ajax({
        url:U,
        cache:false,
        ifModified:true,                        // essential
        mimeType:"text/html",                   // shuts-up ff dev tools 
        dataType:"text"                         // essential 
      })
      /*.always(function(D,S,X){   // log the status
        //var uix = AutoReload._Urls.indexOf(U);
        if(uix>-1){
          AutoReload._responseLog[uix]=X.status;
        }  
      })*/
      .fail(function(X,S,E){
        //console.log('AUTO RELOAD AJAX FAIL:',S+' '+U);
        //console.log('X',X);
        
      })  
      .done(function(D,S,X){     // ignore failure
        // We have some response from the ajax call
        // (1) remove this url from _waiting[]
        var wix = AutoReload._waiting.indexOf(U);
        if(wix>-1){wix = AutoReload._waiting.splice(wix,1);}  
        // (2) see if file has changed      
        
        // Ignore the first to this url because that's always 200
        // If this is call >1 and status is 200 then save state and reload,
        // otherwise go back to the ._Test method to try the next (if any) URL
        //-------------------------------------------------------------------- 
        var uix = AutoReload._Urls.indexOf(U);
        if(uix>-1){
          if(AutoReload._firsts[uix]){         // disable immediate reload on 'first' get
            AutoReload._firsts[uix] = false;   // (always 200) the 2nd should be 304 
          }else{
            if(X.status==200){               // CHANGED!
              //console.log('CHANGED',U);
              AutoReload.SaveState();        // save state
              window.location.reload(true);  // do the dirty deed  
            }else{
              if(AutoReload._waiting.length <1){    // is this the last waiting URL?
                //console.log('Completed poll ok');
                AutoReload._pollCompletedAt = Date.now();
              }
            }            
          }  
        }
      });
    });  
  },
  
  

  // Save state according to the out-of-the-box function or
  // replacement function set-up in Start()
  //-------------------------------------------------------
  SaveState      : function(){
    if(AutoReload._saveState){
      if(typeof AutoReload._saveState == 'function'){
        AutoReload._saveState.call();
      }
    }      
  },  
  
  // Load state according to the out-of-the-box function or
  // replacement function set-up in Start()
  //-------------------------------------------------------
  LoadState      : function(){   
    if(AutoReload._loadState){
      if(typeof this._loadState == 'function'){
        this._loadState.call();
      }
    }      
  },    
  
  // Clear any locally saved state and 
  // do an immediate reload
  //-------------------------------------- 
  PurgeState     : function(){
    this._blockSave = true;
    localStorage.removeItem(AutoReload._lsKey);
    window.location.reload(true);
  },

  
  // Stop the interval timer
  Stop       : function(){
    if(AutoReload._int){clearInterval(AutoReload._int);}
  },

  // *Main initiation call*
  // Loads any previously saved state then then starts the watchdog timer 
  // Read any configuration parameters provided by InitialisingObj
  // \  .watchedList  array eg ['index.htm','./style/my.css','./js/my.js']
  // \  .interval     milliseconds between tests
  // \  .latencyId    string  Id of a DOM element used to display how long since the last reload
  // \  .onLoadState  Custom replacement function
  // \  .onSaveState  Custom replacement function
  //-------------------------------------------------------  
  Start        : function(InitialisingObj){
    this.Stop();   // safety 
    this._loadStamp = Date.now();
    
    // read parameters
    var io = InitialisingObj;
    
    if(!io.hasOwnProperty('watchedList')){io.watchedList =  [window.location.href];}
    // add in any files tagged 'watched' in source
    $('script[watched]').each(function(I,E){io.watchedList.push($(E).attr('src'));});  
    $('link[watched]').each(function(I,E){io.watchedList.push($(E).attr('href'));});  

    this._interval = io.interval || 2000;
    this._loadState = io.onLoadState || this._loadState;
    this._saveState = io.onSaveState || this._saveState;
    this._Urls = io.watchedList;
    this._firsts = this._Urls.map(function(){return true;});

    this._latencyId = io.latencyId;
    
    // hash a key to local storage so that each page has a different local store
    var h = 0;
    var u = window.location.href;
    for(var i=u.length-1;i>=0;i--){
     h += u.charCodeAt(i) * (1+(i%3));
    }  
    this._lsKey = 'AR'+h.toFixed(0);
    
    //console.log(' WATCHED URLS\n',this._Urls.join('\n'));
    // load any saved state
    AutoReload.LoadState();

    // kick off the timer (making sure to flag this as first time)    
    AutoReload._int = setInterval(AutoReload._TestUrls,AutoReload._interval);
    
    
    // return the current time
    if(AutoReload._latencyId){$('#'+this._latencyId).html('0');}
    return (new Date().toLocaleTimeString());

  },    

  // *OBSOLETE*
  // collect all scripts and links   
  _ScriptsAndLinks : function(){
    var urls = [document.URL];
    var s = $('script').each(function(I,E){urls.push(E.src);});  
    var l = $('link[rel="stylesheet"]').each(function(I,E){urls.push(E.href);});  
    urls = urls.filter(function(V){
      var rv = true;
      if( V.includes('jquery')||
          V.includes('autoReload')||
          V.includes('PSDNF-min')){rv = false;}
      return rv;
    });     
    return urls;
  }

};


