<?php
/*  One stop for standard control buttons 

The buttons can be used as <A> or trigger javascript functions

Setup:
  Put ctrls-min.css somewhere
  Link to it in <HEAD>
  eg <LINK href='./style/ctrls-min.css' rel='stylesheet' type='text/css'>
Use
  CtrlBut() returns complete html for each button
Note
  All controls have the class ctrl


*/


function CtrlBut($Type,$Id,$Action,$Title=''){
# Return <A> or <SPAN> styled as one of our standard control buttons
# {Type} is one of the following strings for live buttons
#   add,back,bottom,change,down,fly (ie.external link)
#   get,go,help,info,mail,no,put,top,up,view,yes
# or 
#   topx,bottomx,upx,downx  (disabled list navigation)
#
# {Id} is some Id which may be a null string.
#   In the case of a SPAN this will be used as an element Id
#
# {Action} is either http... or a javascript function
#   The {Id} will be substituted into a two percent sign placemarker
#   eg http://some.place?id=%%
#   eg DoMyJsThing(%%)
#
# {Title} becomes a hover-over-hint.  If not supplied then
#   a default is used.
 


  $ty = trim(strtolower($Type));
  $isDisabled = (strrpos($ty,'x')==(strlen($ty)-1));   // x at end is a disabled version
  $isURL = (strpos($Action,'http:')===0);              // http... become <A> else <SPAN>+javascript function

  // class
  $dis = ($isDisabled) ? 'disabled' : '';
  $cl = "class=\"ctrl $dis $ty" . "s\" ";  // class
  
  // title (hover-hint)
  if($Title){
    $hh=$Title;
  }else{  
    switch ($ty){
    case 'add' : $hh = 'Add' ; break;
    case 'back' : $hh = 'Go back' ; break;
    case 'bottom' : $hh = 'Go to end' ; break;
    case 'change' : $hh = 'Change' ; break;
    case 'down' : $hh = 'Next' ; break;
    case 'fly' : $hh = '???' ; break;
    case 'get' : $hh = 'Fetch' ; break;
    case 'go' : $hh = 'Go and do it' ; break;
    case 'help' : $hh = 'Show help' ; break;
    case 'info' : $hh = 'More information' ; break;
    case 'mail' : $hh = 'Mail' ; break;
    case 'no' : $hh = 'Reject' ; break;
    case 'put' : $hh = 'Send' ; break;
    case 'top' : $hh = 'Go to start' ; break;
    case 'up' : $hh = 'Previous' ; break;
    case 'view' : $hh = 'See detail' ; break;
    case 'yes' : $hh = 'Accept' ; break;
    default : 
      $hh = ($isDisabled) ? '' : "*** ILLEGAL BUTTON TYPE ($Type) ***";
    }    
  }
  if($hh){
    if($isDisabled){$hh .= '(Disabled)';}
  }  
      
  
  // build either <A> or <SPAN>
  if($isURL){
    $rv = "<a $cl ";
    if(!$isDisabled){$rv .= "href=\"$Action\" ";}
    $rv .= "title=\"$hh\" > </a>";
  }else{  
    $rv = "<span id=\"%%\" $cl "; 
    if(!$isDisabled){$rv .= " onclick=\"$Action\" ";}
    $rv .= " title=\"$hh\"> </span>";
  }
  
  // substitute ID 
  $rv = str_replace('%%',$Id,$rv);
  return $rv;
}  



  
?>